/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.MyMartian;
import OreSpawn.entities.UFO;
import dangerzone.DangerZone;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.TextureMapper;
import dangerzone.Utils;
import dangerzone.World;
import dangerzone.blocks.Blocks;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.entities.TargetHelper;
import dangerzone.items.Items;
import dangerzone.particles.Particle;
import java.util.List;
import java.util.ListIterator;
import org.newdawn.slick.opengl.Texture;

public class UFOCarrier
extends EntityLiving {
    public float myspeed = 0.0f;
    public float newangle = 0.0f;

    public UFOCarrier(World w) {
        super(w);
        this.maxrenderdist = 300;
        this.uniquename = "OreSpawn:UFO Carrier";
        if (w != null) {
            this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
        }
        this.takesFallDamage = false;
        this.movefrequency = 65;
        this.canSwim = false;
        this.setExperience(150);
        this.height = 2.5f;
        this.width = 6.0f;
        this.setMaxHealth(150.0f);
        this.setHealth(150.0f);
        this.setDefense(1.5f);
        this.setAttackDamage(10.0f);
        this.searchDistance = 28.0f;
        this.attackRange = 3.5f;
        this.temperament = 2;
        this.canFly = true;
        this.setFlying(true);
        this.tower_defense_enable = false;
        this.setCanDespawn(false);
    }

    public void update(float deltaT) {
        if (!this.world.isServer) {
            int howmany = 3 + this.world.rand.nextInt(8);
            int i = 0;
            while (i < howmany) {
                int which = this.world.rand.nextInt(3);
                Particle eb = null;
                float fwdback = 0.0f;
                float leftright = -35.0f;
                if (this.world.rand.nextBoolean()) {
                    fwdback = 180.0f;
                }
                if (this.world.rand.nextBoolean()) {
                    leftright = 35.0f;
                }
                float dx = (float)(4.25 * Math.sin(Math.toRadians(this.rotation_yaw + fwdback + leftright)));
                float dz = (float)(4.25 * Math.cos(Math.toRadians(this.rotation_yaw + fwdback + leftright)));
                dx += (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f;
                dz += (this.world.rand.nextFloat() - this.world.rand.nextFloat()) * 0.25f;
                if (which == 0) {
                    eb = this.world.createParticleByName("DangerZone:ParticleSparkle", this.dimension, this.posx + (double)dx, this.posy + 0.25, this.posz + (double)dz);
                }
                if (which == 1) {
                    eb = this.world.createParticleByName("DangerZone:ParticleSmoke", this.dimension, this.posx + (double)dx, this.posy + 0.25, this.posz + (double)dz);
                }
                if (which == 2) {
                    eb = this.world.createParticleByName("DangerZone:ParticleFire", this.dimension, this.posx + (double)dx, this.posy + 0.25, this.posz + (double)dz);
                }
                if (eb != null) {
                    eb.motionx = this.motionx / 10.0f;
                    eb.motionz = this.motionz / 10.0f;
                    eb.motiony = -0.55f + this.world.rand.nextFloat() * 0.15f;
                    eb.maxlifetime = 35 + DangerZone.rand.nextInt(10);
                    this.world.spawnParticleInWorld(eb);
                }
                ++i;
            }
        }
        super.update(deltaT);
    }

    public Entity findHome() {
        List nearby_list = null;
        nearby_list = DangerZone.server.entityManager.findEntitiesInRange(250.0f, this.dimension, this.posx, this.posy, this.posz);
        if (nearby_list != null && !nearby_list.isEmpty()) {
            Entity e = null;
            ListIterator li = nearby_list.listIterator();
            while (li.hasNext()) {
                e = (Entity)li.next();
                if (!(e instanceof UFO)) continue;
                return e;
            }
        }
        return null;
    }

    public void doEntityAction(float deltaT) {
        int bid;
        Entity e;
        if (!this.isHurt() && !this.deadflag && this.world.rand.nextInt(100) == 1) {
            this.world.playSound(this.getLivingSound(), this.dimension, this.posx, this.posy + (double)(this.getHeight() / 2.0f), this.posz, this.getLivingSoundVolume(), this.getLivingSoundPitch());
        }
        int keep_trying = 15;
        if (this.target == null) {
            this.target = new TargetHelper(this.posx, this.posy + 1.0, this.posz);
        }
        if ((e = this.findHome()) != null && !e.getAttacking()) {
            this.target = new TargetHelper(e, e.posx, e.posy, e.posz);
            if (Utils.getDistanceBetweenEntities((Entity)this, (Entity)e) < 7.0) {
                this.deadflag = true;
            }
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) == 0) {
            int i = 0;
            while (i < 4) {
                if (this.wouldBump(this.posx + (double)(this.motionx * deltaT), this.posy + (double)(this.motiony * deltaT) + (double)i, this.posz + (double)(this.motionz * deltaT), this.getWidth())) {
                    bid = 1;
                }
                ++i;
            }
        }
        if (bid != 0 || this.world.rand.nextInt(50) == 1 || this.target.getDistanceToTarget(this.posx, this.posy, this.posz) < 3.0) {
            bid = 1;
            while (bid != 0 && keep_trying != 0) {
                this.target.setTarget(this.posx + (double)this.world.rand.nextInt(35) - (double)this.world.rand.nextInt(35), this.posy - (double)(4 + this.world.rand.nextInt(8)), this.posz + (double)this.world.rand.nextInt(35) - (double)this.world.rand.nextInt(35));
                bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz);
                if (bid == 0 && !this.CanProbablySee(this.dimension, this.target.targetx, this.target.targety, this.target.targetz, (int)Math.sqrt((this.posx - this.target.targetx) * (this.posx - this.target.targetx) + (this.posz - this.target.targetz) * (this.posz - this.target.targetz) + (this.posy - this.target.targety) * (this.posy - this.target.targety)))) {
                    bid = 1;
                }
                --keep_trying;
                this.myspeed = 0.3f + this.world.rand.nextFloat() * 0.15f;
            }
        }
        if ((bid = this.world.getblock(this.dimension, (int)this.target.targetx, (int)this.target.targety, (int)this.target.targetz)) != 0) {
            this.deadflag = true;
            MyMartian m = null;
            int i = 0;
            while (i < 10) {
                int dox = (int)this.posx + this.world.rand.nextInt(6) - this.world.rand.nextInt(6);
                int doz = (int)this.posz + this.world.rand.nextInt(6) - this.world.rand.nextInt(6);
                int doy = (int)this.posy + 10;
                int j = 0;
                while (j < 20) {
                    if (this.world.getblock(this.dimension, dox, doy - j, doz) != 0) {
                        doy = doy - j + 1;
                        break;
                    }
                    ++j;
                }
                m = (MyMartian)this.world.createEntityByName("OreSpawn:Martian", this.dimension, (double)dox, (double)doy, (double)doz);
                if (m != null) {
                    m.init();
                    int itd = OreSpawnMain.raygun.itemID;
                    if (this.world.rand.nextBoolean()) {
                        itd = Items.bow.itemID;
                    }
                    InventoryContainer ic = new InventoryContainer();
                    ic.iid = itd;
                    ic.count = 1;
                    ic.currentuses = 0;
                    m.setHotbar(0, ic);
                    m.sethotbarindex(0);
                    ic = new InventoryContainer();
                    ic.iid = Items.arrow.itemID;
                    ic.count = 64;
                    m.setHotbar(1, ic);
                    ic = new InventoryContainer();
                    ic.iid = Items.arrow.itemID;
                    ic.count = 64;
                    m.setHotbar(2, ic);
                    ic = new InventoryContainer();
                    ic.iid = Items.arrow.itemID;
                    ic.count = 64;
                    m.setHotbar(3, ic);
                    ic = new InventoryContainer();
                    ic.iid = Items.arrow.itemID;
                    ic.count = 64;
                    m.setHotbar(4, ic);
                    m.setInitialized(1);
                    this.world.spawnEntityInWorld((Entity)m);
                }
                ++i;
            }
        }
        double dy = this.target.targety - this.posy;
        this.motiony += 0.12f * deltaT;
        if ((dy /= 20.0) > (double)0.2f) {
            dy = 0.2f;
        }
        if (dy < (double)-0.2f) {
            dy = -0.2f;
        }
        this.motiony = (float)((double)this.motiony + dy);
        if (this.motiony > 1.0f) {
            this.motiony = 1.0f;
        }
        if (this.motiony < -1.0f) {
            this.motiony = -1.0f;
        }
        float cdir = (float)Math.toRadians(this.rotation_yaw);
        float tdir = (float)Math.atan2(this.target.targetx - this.posx, this.target.targetz - this.posz);
        float ddiff = tdir - cdir;
        while ((double)ddiff > Math.PI) {
            ddiff = (float)((double)ddiff - Math.PI * 2);
        }
        while ((double)ddiff < -Math.PI) {
            ddiff = (float)((double)ddiff + Math.PI * 2);
        }
        this.rotation_yaw_motion = (float)((double)this.rotation_yaw_motion + (double)(ddiff * 180.0f) / Math.PI / 10.0);
        float speedadjust = 1.0f;
        float effectspeed = this.getTotalEffect(1);
        if (effectspeed > 1.0f) {
            speedadjust *= effectspeed;
        }
        if ((effectspeed = this.getTotalEffect(2)) > 1.0f) {
            speedadjust /= effectspeed;
        }
        this.motionx = (float)((double)this.motionx + (double)(this.myspeed * speedadjust) * Math.sin(tdir) * (double)deltaT);
        this.motionz = (float)((double)this.motionz + (double)(this.myspeed * speedadjust) * Math.cos(tdir) * (double)deltaT);
        double dist = 0.0;
        Player p = DangerZone.server.findNearestPlayer((Entity)this);
        if (p == null) {
            this.deadflag = true;
        } else {
            dist = Utils.getHorizontalDistanceBetweenEntities((Entity)this, (Entity)p);
            if (dist > (double)DangerZone.entityupdatedist) {
                this.deadflag = true;
            } else if (dist > (double)(DangerZone.entityupdatedist / 2)) {
                if (this.world.rand.nextInt(500) == 0) {
                    this.deadflag = true;
                }
            } else if (dist > (double)(DangerZone.entityupdatedist / 4)) {
                if (this.world.rand.nextInt(1250) == 0) {
                    this.deadflag = true;
                }
            } else if (dist > (double)(DangerZone.entityupdatedist / 8) && this.world.rand.nextInt(2500) == 0) {
                this.deadflag = true;
            }
        }
    }

    public boolean isSuitableTarget(Entity e) {
        return false;
    }

    public void doDeathDrops() {
        int i = 0;
        while (i < 20) {
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.dark.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.light.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.instability.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.lumpcopper.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.lumptin.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.lumpsilver.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)Items.lumpplatinum.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.laserball.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(4) == 1) {
                Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.raygun.itemID, (float)16.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand((World)this.world, (int)Blocks.blockcopper.blockID, (int)0, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand((World)this.world, (int)Blocks.blocktin.blockID, (int)0, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand((World)this.world, (int)Blocks.blocksilver.blockID, (int)0, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            if (this.world.rand.nextInt(8) == 1) {
                Utils.doDropRand((World)this.world, (int)Blocks.blockplatinum.blockID, (int)0, (float)8.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
            }
            ++i;
        }
        super.doDeathDrops();
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/UFO_Carriertexture.png");
        }
        return this.texture;
    }

    public String getHurtSound() {
        return "OreSpawn:dragonfly_hurt";
    }

    public String getDeathSound() {
        int which = this.world.rand.nextInt(3);
        if (which == 0) {
            return "DangerZone:large_explosion1";
        }
        if (which == 1) {
            return "DangerZone:large_explosion2";
        }
        return "DangerZone:large_explosion3";
    }

    public String getLivingSound() {
        int which = this.world.rand.nextInt(17);
        if (which == 0) {
            return "OreSpawn:hover1";
        }
        if (which == 1) {
            return "OreSpawn:hover2";
        }
        if (which == 2) {
            return "OreSpawn:hover3";
        }
        if (which == 3) {
            return "OreSpawn:hover4";
        }
        if (which == 4) {
            return "OreSpawn:hover5";
        }
        if (which == 5) {
            return "OreSpawn:hover6";
        }
        if (which == 6) {
            return "OreSpawn:robotspider1";
        }
        if (which == 7) {
            return "OreSpawn:robotspider2";
        }
        if (which == 8) {
            return "OreSpawn:robotspider3";
        }
        if (which == 9) {
            return "OreSpawn:robotspider4";
        }
        if (which == 10) {
            return "OreSpawn:robotspider5";
        }
        if (which == 11) {
            return "OreSpawn:robotspider6";
        }
        if (which == 12) {
            return "OreSpawn:robotspider7";
        }
        if (which == 13) {
            return "OreSpawn:robotspider8";
        }
        if (which == 14) {
            return "OreSpawn:robotspider9";
        }
        if (which == 15) {
            return "OreSpawn:robotspider10";
        }
        if (which == 16) {
            return "OreSpawn:robotspider11";
        }
        return null;
    }

    public void setBaby(boolean tf) {
    }
}

